#include "jeu.h"

#define TENTATIVES_CONNEXION_MAX 5
#define DELAI_ENTRE_TENTATIVES 1000
#define CHARGEMENT_TERMINE (1 | 2 | 4 | 8 | 16 | 32)

void lecture_message(t_paquet *mess, t_interface *inter, t_partie *jeu);
void pause();

long initialiser_jeu(t_interface *interface, t_partie *jeu, t_serveur *serv)
{
    long j, n; // Compteur d'indice
    char str[255];
    str[0]=0;

    SDL_Surface *splash,*texte;
    SDL_Color couleur;
    char pseudos[11][32]={
    "Roi Arthur",
    "Lancelot",
    "Perceval",
    "Karadoc",
    "Lodagan",
    "Bohort",
    "Kadoc",
    "Pre Blaise",
    "Merlin",
    "Gauvain",
    "Yvain"
    };
    srand(time(NULL));
    couleur.r=0;
    couleur.g=0;
    couleur.b=0;

    interface->accent=0;// Pas d'accent retenu en memoire

    sprintf(str,"%s%s",RESSOURCES_DIR,POLICE_TEXTE); // On rcupre le chemin de l'image
    interface->font = TTF_OpenFont(str, POLICE_TAILLE_NORMALE); // On charge la Police de caractre

    sprintf(str,"%s%s",RESSOURCES_DIR,"splash.png"); // On rcupre le chemin de l'image
    splash=IMG_Load(str);// On charge l'image du fond
    if ( !splash ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    //Initialisation de donnes pour la partie
    jeu->nbr_joueurs = 1;
    jeu->joueurs = (t_joueur *)malloc((jeu->nbr_joueurs) * sizeof(t_joueur));

    jeu->joueurs[0].pseudo = (char *)malloc(strlen("Serveur") + 1);
    strcpy(jeu->joueurs[0].pseudo, "Serveur");
    jeu->joueurs[0].camp_x = 0;
    jeu->joueurs[0].camp_y = 0;
    jeu->joueurs[0].tileset = NULL;
    jeu->joueurs[0].couleur.r = 255;
    jeu->joueurs[0].couleur.g = 255;
    jeu->joueurs[0].couleur.b = 255;
    sprintf(str,"%s%s",RESSOURCES_DIR,"arthur0.png"); // On rcupre le chemin de l'image
    jeu->joueurs[0].avatar=IMG_Load(str);// On charge l'image du bouton
    jeu->nbr_pions = 0;
    jeu->pions = NULL;

    /**Chargement des donnes depuis le serveur**/
    interface->gui_taille = 0; //Tant qu'on a pas charg l'interface, on ignore l'affichage de message
    jeu->map.paquets = 0; //On ne sait pas encore combien de paquets il faudra tlcharger pour la map
    jeu->map.i = -1;
    jeu->map.tileset.paquets = 0; //Ni pour le tileset
    jeu->map.tileset.i = -1;

    //Connexion
    n = 0;
    while(n < TENTATIVES_CONNEXION_MAX)
    {
        //Petit message pour patienter
        SDL_BlitSurface(splash,0,interface->fenetre,0);
        sprintf(str, "Connexion  %s:%ld (tentative n%ld)...", serv->dns, serv->port, n + 1);
        texte=TTF_RenderText_Blended(interface->font, str , couleur); //On place le texte dans la surface temporaire
        SDL_BlitSurface(texte,0,interface->fenetre,0);
        SDL_Flip(interface->fenetre);
        SDL_FreeSurface(texte);

        if(connecter(interface, serv, serv->dns)) {n = TENTATIVES_CONNEXION_MAX + 1;}
        else
        {
            n++;
            pause();
        }
    }
    if(n == TENTATIVES_CONNEXION_MAX + 1)
    {
        //Petit message pour patienter
        SDL_BlitSurface(splash,0,interface->fenetre,0);
        sprintf(str, "Chargement...");
        texte=TTF_RenderText_Blended(interface->font, str , couleur);// On place le texte dans la surface temporaire
        SDL_BlitSurface(texte,0,interface->fenetre,0);
        SDL_Flip(interface->fenetre);
        SDL_FreeSurface(texte);
    }
    else
    {
        //Petit message pour patienter
        SDL_BlitSurface(splash,0,interface->fenetre,0);
        sprintf(str, "chec de la connexion  %s:%ld...", serv->dns, serv->port);
        texte=TTF_RenderText_Blended(interface->font, str , couleur);// On place le texte dans la surface temporaire
        SDL_BlitSurface(texte,0,interface->fenetre,0);
        SDL_Flip(interface->fenetre);
        SDL_FreeSurface(texte);

        pause(); pause(); pause();
        system(CMD_LINE);
        exit(0); //Rien ne sert de continuer le programme
    }

    SDLNet_Write32((1 << 24 | 0 << 16 | 0 << 8 | 0), str); //Version 1.0.0.0

    if (interface->options.pseudo==NULL)
    {
        interface->options.pseudo=pseudos[rand()%11];
    }

    strcpy(str + 4,interface->options.pseudo);

    communiquer(VERSION, strlen(str + 4) + 5, str, serv); //Envoie de la version et du pseudo
    jeu->charge = 0;
    while(jeu->charge != CHARGEMENT_TERMINE && jeu->charge != -1)
    {
        traiter_paquets(interface, serv, jeu);
        SDL_Delay(10); //Petit dlai pour soulager le processeur
    }
    if(jeu->charge == -1)
    {
        //Petit message pour patienter
        SDL_BlitSurface(splash,0,interface->fenetre,0);
        sprintf(str, "Votre pseudo (%s) est dj utilis (ou n'est pas admis).", interface->options.pseudo);
        texte=TTF_RenderText_Blended(interface->font, str , couleur);// On place le texte dans la surface temporaire
        SDL_BlitSurface(texte,0,interface->fenetre,0);
        SDL_Flip(interface->fenetre);
        SDL_FreeSurface(texte);

        pause(); pause(); pause();
        system(CMD_LINE);
        exit(0); //Rien ne sert de continuer le programme
    }
    initialiser_interface(interface,jeu);
    actualiser_minimap(jeu,interface);

    for(j = 1; j <= jeu->nbr_joueurs; j++)
    {
        if(j == 1)
        {
            jeu->joueurs[j].couleur.r = 0;
            jeu->joueurs[j].couleur.g = 0;
            jeu->joueurs[j].couleur.b = 255;
        }
        else if(j == 2)
        {
            jeu->joueurs[j].couleur.r = 255;
            jeu->joueurs[j].couleur.g = 0;
            jeu->joueurs[j].couleur.b = 0;
        }
        else if(j == 3)
        {
            jeu->joueurs[j].couleur.r = 0;
            jeu->joueurs[j].couleur.g = 255;
            jeu->joueurs[j].couleur.b = 0;
        }
        else if(j == 4)
        {
            jeu->joueurs[j].couleur.r = 255;
            jeu->joueurs[j].couleur.g = 255;
            jeu->joueurs[j].couleur.b = 0;
        }
        else
        {
            system(CMD_LINE);
            exit(0); //Rien ne sert de continuer le programme
        }

        jeu->joueurs[j].tileset=(t_tileset*)malloc(4*sizeof(t_tileset));
        for(n = 0; n < 4; n++)
        {
            switch(n)
            {
                case ECLAIREUR:
                    jeu->joueurs[j].tileset[n].fichier=(char *)malloc(strlen(RESSOURCES_DIR)+strlen("eclaireurX.png")+1);
                    sprintf(jeu->joueurs[j].tileset[n].fichier,"%seclaireur%ld.png",RESSOURCES_DIR,j);
                    break;
                case PECORE:
                    jeu->joueurs[j].tileset[n].fichier=(char *)malloc(strlen(RESSOURCES_DIR)+strlen("pecoreX.png")+1);
                    sprintf(jeu->joueurs[j].tileset[n].fichier,"%specore%ld.png",RESSOURCES_DIR,j);
                    break;
                case CHEVALIER:
                    jeu->joueurs[j].tileset[n].fichier=(char *)malloc(strlen(RESSOURCES_DIR)+strlen("chevalierX.png")+1);
                    sprintf(jeu->joueurs[j].tileset[n].fichier,"%schevalier%ld.png",RESSOURCES_DIR,j);
                    break;
                default:
                    jeu->joueurs[j].tileset[n].fichier=(char *)malloc(strlen(RESSOURCES_DIR)+strlen("graalX.png")+1);
                    sprintf(jeu->joueurs[j].tileset[n].fichier,"%sgraal%ld.png",RESSOURCES_DIR,j);
                    break;
            }
            charger_tileset(&jeu->joueurs[j].tileset[n],0);
        }

        str[0]=0;
        sprintf(str,"%sarthur%ld.png",RESSOURCES_DIR,j);
        jeu->joueurs[j].avatar=IMG_Load(str);// On charge l'image du bouton
        if ( !jeu->joueurs[j].avatar ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    }

    actualiser_brouillard(interface, jeu);
    Mix_Volume(-1, interface->options.volume_son);
    jeu->sons=(Mix_Chunk ***)malloc(5*sizeof(Mix_Chunk **));

    jeu->sons[0]=(Mix_Chunk **)malloc(4*sizeof(Mix_Chunk *));

    sprintf(str,"%sdebut.ogg",SOUNDS_DIR);
    jeu->sons[0][0]=Mix_LoadWAV(str);
    if (jeu->sons[0][0]==NULL)
    {
        printf("Impossible de charger le son %s",str);
    }

    sprintf(str,"%smessage.ogg",SOUNDS_DIR);
    jeu->sons[0][1]=Mix_LoadWAV(str);
    if (jeu->sons[0][1]==NULL)
    {
        printf("Impossible de charger le son %s",str);
    }

    sprintf(str,"%svictoire.ogg",SOUNDS_DIR);
    jeu->sons[0][2]=Mix_LoadWAV(str);
    if (jeu->sons[0][2]==NULL)
    {
        printf("Impossible de charger le son %s",str);
    }

    sprintf(str,"%sswoosh.ogg",SOUNDS_DIR);
    jeu->sons[0][3]=Mix_LoadWAV(str);
    if (jeu->sons[0][3]==NULL)
    {
        printf("Impossible de charger le son %s",str);
    }

    // Et on charge les sons
    for (n=1; n<5;n++)
    {
        jeu->sons[n]=(Mix_Chunk **)malloc(15*sizeof(Mix_Chunk *));

        for (j=0;j<15;j++)
        {
            str[0]=0;
            if (n==1)
            {
                sprintf(str,"%seclaireurA - %ld.ogg",SOUNDS_DIR,j+1);
            }
            else if (n==2)
            {
                sprintf(str,"%specoreA - %ld.ogg",SOUNDS_DIR,j+1);
            }
            else if (n==3)
            {
                sprintf(str,"%schevalierA - %ld.ogg",SOUNDS_DIR,j+1);
            }
            else if (n==4)
            {
                sprintf(str,"%schevalierB - %ld.ogg",SOUNDS_DIR,j+1);
            }

            jeu->sons[n][j]=Mix_LoadWAV(str);
            if (jeu->sons[n][j]==NULL)
            {
                printf("Impossible de charger le son %s",str);
            }
        }

    }

    Mix_PlayChannel (-1, jeu->sons[0][0], 0);
    Mix_PlayMusic(interface->musique,-1);

    SDL_FreeSurface(splash);
    afficher_message(interface, "Rmi Jarasson et Loc Belmonte vous souhaitent un bon jeu !", 255, 255, 255);
    afficher_message(interface, "La partie va bientt commencer (attente des autres joueurs).", jeu->joueurs[jeu->joueur].couleur.r, jeu->joueurs[jeu->joueur].couleur.g, jeu->joueurs[jeu->joueur].couleur.b);
    return 0;
}

void liberer_jeu(t_partie *jeu)
{
  long n, j;

  free(jeu->joueurs[0].pseudo);
  for(j = 1; j <= jeu->nbr_joueurs; j++)
  {
    for(n = 0; n < 4; n++)
    {
      SDL_FreeSurface(jeu->joueurs[j].tileset[n].image);
      free(jeu->joueurs[j].tileset[n].fichier);
    }
    SDL_FreeSurface(jeu->joueurs[j].avatar);
    free(jeu->joueurs[j].tileset);
    free(jeu->joueurs[j].pseudo);
  }
  free(jeu->pions);

  for (n = 0; n < 4; n++)
  {
        Mix_FreeChunk(jeu->sons[0][n]);
  }

  for (n = 1; n < 5; n++)
  {
      for (j = 0; j < 15; j++)
      {
          Mix_FreeChunk(jeu->sons[n][j]);
      }
      free(jeu->sons[n]);
  }

  free(jeu->sons);
  free(jeu->joueurs);
  return;
}

long charger_tileset(t_tileset *tileset,long alpha)
{
    tileset->image=IMG_Load(tileset->fichier);// On charge l'image du tileset
    if ( !tileset->image )
    {
        printf ( "IMG_Load: L'image n'a pas pu tre charge: %s\n", IMG_GetError () ); // ERREUR
        return 1;
    }
    else
    {
        if(!alpha)
        {

            SDL_SetColorKey(tileset->image, SDL_SRCCOLORKEY, SDL_MapRGB(tileset->image->format, 255, 0, 255)); // Le noir sera transparent
            tileset->image->format->Amask=0;
            SDL_SetAlpha(tileset->image,0,128);
        }
        // On dfinit la largeur et la hauteur du tileset
        tileset->largeur=tileset->image->w / TILE_TAILLE;// nombre de tiles en largeur
        tileset->hauteur=tileset->image->h / TILE_TAILLE;// nombre de tiles en hauteur
        return 0;
    }
}

long ajouter_pion(t_partie *jeu, long joueur, type_pion type, long pts, long x, long y)
{
    jeu->pions=(t_pion *)realloc(jeu->pions,(jeu->nbr_pions+1)*sizeof(t_pion));


    if (jeu->pions)
    {
        jeu->pions[jeu->nbr_pions].joueur=joueur;
        jeu->pions[jeu->nbr_pions].type=type;
        jeu->pions[jeu->nbr_pions].pts_max=pts;
        jeu->pions[jeu->nbr_pions].pts=0;
        jeu->pions[jeu->nbr_pions].angle=0;
        jeu->pions[jeu->nbr_pions].pos_x=x;
        jeu->pions[jeu->nbr_pions].pos_y=y;
        jeu->pions[jeu->nbr_pions].graal=0;
        jeu->pions[jeu->nbr_pions].anim=NULL;
        jeu->nbr_pions++;
        return 0;
    }
    else
    {
        return 1; // Code erreur;
    }
}

long ajouter_anim(t_pion *pion, enum anim_type type, long x, long y, long valeur)
{
    t_anim_liste **ptr;
    ptr=&pion->anim;

    while(*ptr)
    {
        ptr=&(*ptr)->suivant;
    }

    *ptr=(t_anim_liste *)malloc(sizeof(t_anim_liste));

    if(*ptr)
    {
        (*ptr)->type=type;
        (*ptr)->x=x;
        (*ptr)->y=y;
        (*ptr)->valeur=valeur;
        (*ptr)->frame=0;
        (*ptr)->suivant=NULL;

        return 0;
    }
    else
    {
        return 1; // Code erreur
    }
}

void afficher_pions(t_interface *interface,t_partie *jeu)
{
    long n; // Compteurs d'indice
    long tile;// Contient l'angle du personnage
    long alpha; // Contient l'alpha du personnage
    static long frame=0; // Contient un indice de frame pour une animation quelconque
    SDL_Rect position, position_backup, crop; // Coordonnes de positionnement, et de rognage
    SDL_Rect offset; // Coordonnes utilise par l'animation
    SDL_Rect origine, destination;
    SDL_Rect fleche;
    fleche.w=0;
    fleche.h=0;
    t_anim_liste *ptr;
    char str[255];
    str[0]=0;

    // On rogne le tileset pour n'avoir qu'une seule tile....

    for(n=0;n<jeu->nbr_pions;n++)
    {
        crop.h=TILE_TAILLE;
        crop.w=TILE_TAILLE;
        if(jeu->map.cases[jeu->pions[n].pos_y][jeu->pions[n].pos_x].etat==VISIBLE || interface->options.poulette || jeu->pions[n].anim)
        {
            position.x=jeu->pions[n].pos_x*TILE_TAILLE-interface->gui[0]->crop.x; // On transforme les coordonnes de la tile en coordonnes en pixels
            position.y=jeu->pions[n].pos_y*TILE_TAILLE-interface->gui[0]->crop.y;   // On transforme les coordonnes de la tile en coordonnes en pixels
            if (jeu->pions[n].type == CHEVALIER ||
                jeu->pions[n].type == ECLAIREUR ||
                jeu->pions[n].type == PECORE)
            {
                tile=jeu->pions[n].angle*5;
            }
            else
            {
                tile=0;
            }

            if(jeu->map.cases[jeu->pions[n].pos_y][jeu->pions[n].pos_x].etat==VISIBLE || interface->options.poulette)
            {
                alpha=255;
            }
            else
            {
                alpha=0;
            }

            if (jeu->pions[n].anim)
            {
                jeu->pions[n].anim->frame++;
                switch(jeu->pions[n].anim->type)
                {
                    case DEPLACEMENT:


                        offset.x=jeu->pions[n].anim->x;
                        offset.y=jeu->pions[n].anim->y;

                        jeu->pions[n].angle=obtenir_angle( offset.x,  offset.y);

                        if (interface->options.moonwalk)
                        {
                            jeu->pions[n].angle=(jeu->pions[n].angle+4)%8;
                        }

                        tile=jeu->pions[n].angle*5;
                        tile+=1+((jeu->pions[n].anim->frame/8) %4);


                        if(jeu->pions[n].anim->frame<=16)
                        {
                            position.x+=(jeu->pions[n].anim->frame)*offset.x;
                            position.y+=(jeu->pions[n].anim->frame)*offset.y;
                            origine.x=jeu->pions[n].pos_x;
                            origine.y=jeu->pions[n].pos_y;
                            destination.x=jeu->pions[n].pos_x+offset.x;
                            destination.y=jeu->pions[n].pos_y+offset.y;

                        }
                        else
                        {
                            position.x-=(32-jeu->pions[n].anim->frame)*offset.x;
                            position.y-=(32-jeu->pions[n].anim->frame)*offset.y;
                            origine.x=jeu->pions[n].pos_x-offset.x;
                            origine.y=jeu->pions[n].pos_y-offset.y;
                            destination.x=jeu->pions[n].pos_x;
                            destination.y=jeu->pions[n].pos_y;
                        }


                        if (jeu->pions[n].joueur!=jeu->joueur) // Pour le moment on considre que le joueur actuel est le joueur 1...
                        {
                            if (!interface->options.poulette)
                            {
                                if (jeu->map.cases[origine.y][origine.x].etat==VISIBLE &&
                                jeu->map.cases[destination.y][destination.x].etat!=VISIBLE)
                                {
                                    alpha=256-(jeu->pions[n].anim->frame * 8);
                                }
                                else if (jeu->map.cases[origine.y][origine.x].etat!=VISIBLE &&
                                jeu->map.cases[destination.y][destination.x].etat==VISIBLE)
                                {
                                    alpha=((jeu->pions[n].anim->frame-1) * 8);
                                }
                            }

                        }


                        if (jeu->pions[n].anim->frame==16)
                        {
                            jeu->pions[n].pos_x+=offset.x;
                            jeu->pions[n].pos_y+=offset.y;
                            actualiser_brouillard(interface,jeu);
                        }

                        break;
                    case TELEPORTATION:
                        if (jeu->pions[n].anim->frame==1)
                        {
                            Mix_PlayChannel (-1, jeu->sons[0][3], 0); // On lit le son Swoosh
                        }
                        jeu->pions[n].angle=jeu->pions[n].anim->frame%8;
                        tile=jeu->pions[n].angle*5;

                        if (jeu->pions[n].anim->frame==16)
                        {

                            jeu->pions[n].pos_x=jeu->pions[n].anim->x;
                            jeu->pions[n].pos_y=jeu->pions[n].anim->y;

                            actualiser_brouillard(interface,jeu);
                        }

                        break;
                    default:
                        break;
                }
                if (jeu->pions[n].anim->frame==32)
                {
                    ptr=jeu->pions[n].anim;
                    jeu->pions[n].anim=jeu->pions[n].anim->suivant;

                    free(ptr);
                }
            }

            if (position.x>-32 && position.x<interface->gui[0]->crop.w)
            {
                if (position.y>-32 && position.y<interface->gui[0]->crop.h)
                {
                    if(alpha)
                    {
                        position_backup=position;
                        if (jeu->pions[n].type!=GRAAL)
                        {
                            // Effet d'ombre
                            conversion_tile_tileset(3,jeu->map.fx.largeur,jeu->map.fx.hauteur,&crop);
                            // On blitte l'effet par dessus la tile de terrain
                            SDL_BlitSurface(jeu->map.fx.image, &crop, interface->gui[0]->image, &position);
                            position=position_backup;
                        }

                        if (jeu->pions[n].graal)
                        {
                            // Effet de Halo
                            position.y-=8;
                            conversion_tile_tileset(6,jeu->map.fx.largeur,jeu->map.fx.hauteur,&crop);
                            // On blitte l'effet par dessus la tile de terrain
                            SDL_BlitSurface(jeu->map.fx.image, &crop, interface->gui[0]->image, &position);



                            position=position_backup;
                        }

                        if(jeu->pions[n].type != GRAAL || jeu->pions[n].graal == 0) //On affiche pas un graal port
                        {
                            SDL_SetAlpha(jeu->joueurs[jeu->pions[n].joueur].tileset[jeu->pions[n].type].image,SDL_SRCALPHA,alpha);

                            conversion_tile_tileset(tile,jeu->joueurs[jeu->pions[n].joueur].tileset[jeu->pions[n].type].largeur,jeu->joueurs[jeu->pions[n].joueur].tileset[jeu->pions[n].type].hauteur,&crop);
                            SDL_BlitSurface(jeu->joueurs[jeu->pions[n].joueur].tileset[jeu->pions[n].type].image, &crop, interface->gui[0]->image, &position);
                            position=position_backup;

                            if (interface->pion==n)
                            {
                                fleche.w=1; // On active le curseur
                                fleche.x=position.x;
                                fleche.y=position.y-(TILE_TAILLE+(frame/2));
                                if (frame>=6)
                                {
                                    fleche.y+=2;
                                }

                            }
                        }
                    }
                }
            }
        }
    }
    frame=(frame+1)%8;
    if (fleche.w)
    {
        conversion_tile_tileset(5,jeu->map.fx.largeur,jeu->map.fx.hauteur,&crop);
        // On blitte l'effet par dessus la tile de terrain
        SDL_BlitSurface(jeu->map.fx.image, &crop, interface->gui[0]->image, &fleche);
    }
}

void actualiser_brouillard(t_interface * interface,t_partie *jeu)
{
    long n,x,y, dest_x, dest_y;
    long distance;

    // D'abord on efface l'ancienne partie visible
    for(y=0;y<jeu->map.hauteur;y++)
    {
        for(x=0;x<jeu->map.largeur;x++)
        {
                if (jeu->map.cases[y][x].etat == VISIBLE)
                {
                    jeu->map.cases[y][x].etat=MASQUE;
                }
        }
    }

    for (n=0; n<jeu->nbr_pions;n++)
    {
        if (jeu->pions[n].joueur==jeu->joueur)
        {
            dest_x=jeu->pions[n].pos_x;
            dest_y=jeu->pions[n].pos_y;

            // On rend explor la position cible
            for(x=dest_x-interface->options.distance_inconnu;x<=dest_x+interface->options.distance_inconnu;x++)
            {
                for(y=dest_y-interface->options.distance_inconnu;y<=dest_y+interface->options.distance_inconnu;y++)
                {
                    if (x>=0 && y>=0 && x<jeu->map.largeur && y<jeu->map.hauteur)
                    {
                        distance=(x-dest_x)*(x-dest_x)+(y-dest_y)*(y-dest_y);
                        if (distance<=(interface->options.distance_inconnu*interface->options.distance_inconnu))
                        {
                            if (jeu->map.cases[y][x].etat == INCONNU)
                            {
                                jeu->map.cases[y][x].etat = MASQUE;
                            }
                        }
                    }
                }
            }

            // On rtablit une visibilit
            for(x=dest_x-interface->options.distance_visible;x<=dest_x+interface->options.distance_visible;x++)
            {
                for(y=dest_y-interface->options.distance_visible;y<=dest_y+interface->options.distance_visible;y++)
                {
                    if (x>=0 && y>=0 && x<jeu->map.largeur && y<jeu->map.hauteur)
                    {

                        distance=(x-dest_x)*(x-dest_x)+(y-dest_y)*(y-dest_y);
                        if (distance<=(interface->options.distance_visible*interface->options.distance_visible))
                        {
                            if (jeu->map.cases[y][x].etat != INCONNU)
                            {
                                jeu->map.cases[y][x].etat = VISIBLE;
                            }
                        }
                    }
                }
            }
        }
    }


    actualiser_minimap(jeu,interface);
}


void bouger_pion(t_interface *interface, t_serveur *serv, t_partie *jeu, long pion)
{
    char buffer[BUFFER_MAX];
    long offset_x=0,offset_y=0;
    long dance=0;
    static long req_prec_pion = -1, req_prec_x = -1, req_prec_y = -1;

    if (!interface->gui_actif)
    {

    if (!jeu->pions[pion].anim)
    {
        switch(interface->touche) // On vrifie la touche enfonce
        {
            case SDLK_q:
            case SDLK_KP7:
                offset_x--;
                offset_y--;
                break;
            case SDLK_w:
            case SDLK_KP8:
                offset_y--;
                break;
            case SDLK_e:
            case SDLK_KP9:
                offset_x++;
                offset_y--;
                break;
            case SDLK_a:
            case SDLK_KP4:
                offset_x--;
                break;
            case SDLK_d:
            case SDLK_KP6:
                offset_x++;
                break;
            case SDLK_z:
            case SDLK_KP1:
                offset_x--;
                offset_y++;
                break;
            case SDLK_x:
            case SDLK_KP2:
                offset_y++;
                break;
            case SDLK_c:
            case SDLK_KP3:
                offset_x++;
                offset_y++;
                break;
            case SDLK_s:
            case SDLK_KP5:
                if (interface->options.moonwalk)
                {
                    dance=1;
                }
                break;
            default:
                break;
        }

        if (dance)
        {
            if(ajouter_anim(&jeu->pions[pion],TELEPORTATION,jeu->pions[pion].pos_x,jeu->pions[pion].pos_y,0)){exit(33);}
        }
        else if(offset_x!=0 || offset_y!=0)
        {
            if (pion != req_prec_pion || jeu->pions[pion].pos_x + offset_x != req_prec_x || jeu->pions[pion].pos_y + offset_y != req_prec_y)
            {
                req_prec_pion = pion;
                req_prec_x  = jeu->pions[pion].pos_x + offset_x;
                req_prec_y = jeu->pions[pion].pos_y + offset_y;
                SDLNet_Write32(req_prec_pion, buffer);
                SDLNet_Write32(req_prec_x, buffer + 4);
                SDLNet_Write32(req_prec_y, buffer + 8);
                communiquer(PAQUET_DEPLACEMENT, 12, buffer, serv);
            }
        }
        else
        {
             req_prec_pion = -1;
             req_prec_x = -1;
             req_prec_y = -1;
        }
    }
    }
}

enum pion_angle obtenir_angle(long x, long y)
{

    if(x==0)
    {
        if(y>0){return S;}
        else{return N;}
    }
    else if (x>0)
    {
        if(y>0){return SE;}
        else if(y<0){return NE;}
        else {return E;}
    }
    else
    {
        if(y>0){return SO;}
        else if(y<0){return NO;}
        else {return O;}
    }
}

void traiter_paquets(t_interface *inter, t_serveur *serv, t_partie *jeu)
{
    FILE *fichier;
    t_paquet *temp_paquet; //Pointeur sur un paquet pour effacer
    char buffer[BUFFER_MAX];
    long i, temp;

    while((serv->connecte >= 0) && (serv->paquets->suivant != NULL)) //Tant qu'il y a des messages  traiter
    {
        //On supprime l'ancien paquet
        temp_paquet = serv->paquets;
        serv->paquets = serv->paquets->suivant;
        temp_paquet->suivant = NULL;
        supprimer_paquets(temp_paquet);
        //Et on traite le nouveau
        switch(serv->paquets->type)
        {
            case ERREUR_DECO: //S'il y a eu une erreur ou une dconnexion
                deconnecter(serv); //On libre la mmoire inutilise
                if(jeu->charge == CHARGEMENT_TERMINE) afficher_message(inter, "Vous avez t dconnect du serveur !", 255, 255, 0);
                else {jeu->charge = -1;}
                break;
            case MESSAGE:
                lecture_message(serv->paquets, inter, jeu);
                break;
            case INFO:
                jeu->nbr_joueurs = SDLNet_Read32(serv->paquets->donnee);
                jeu->joueur = SDLNet_Read32(serv->paquets->donnee + 4);
                jeu->joueurs = (t_joueur *)realloc(jeu->joueurs, (jeu->nbr_joueurs + 1) * sizeof(t_joueur));
                inter->options.distance_inconnu = SDLNet_Read32(serv->paquets->donnee + 8);
                inter->options.distance_visible = SDLNet_Read32(serv->paquets->donnee + 12);
                for(temp = 1; temp <= jeu->nbr_joueurs; temp++) {jeu->joueurs[temp].pseudo = NULL;}
                jeu->charge |= 1;
                break;
            case PSEUDO:
                temp = SDLNet_Read32(serv->paquets->donnee);
                if(jeu->joueurs[temp].pseudo) {free(jeu->joueurs[temp].pseudo);}
                jeu->joueurs[temp].pseudo = (char *)malloc(strlen(serv->paquets->donnee + 4) + 1);
                strcpy(jeu->joueurs[temp].pseudo, serv->paquets->donnee + 4);
                sprintf(buffer, "%s vient de se connecter !", jeu->joueurs[temp].pseudo);
                afficher_message(inter, buffer, jeu->joueurs[temp].couleur.r, jeu->joueurs[temp].couleur.g, jeu->joueurs[temp].couleur.b);
                jeu->charge |= 2;
                break;
            case BASE:
                temp = SDLNet_Read32(serv->paquets->donnee);
                jeu->joueurs[temp].camp_x = SDLNet_Read32(serv->paquets->donnee + 4);
                jeu->joueurs[temp].camp_y = SDLNet_Read32(serv->paquets->donnee + 8);
                jeu->charge |= 4;
                break;
            case PAQUET_MAP:
                if(jeu->map.paquets == 0) //Si on n'a pas entam le tlchargement de la map
                {
                    jeu->map.i = 0;
                    jeu->map.paquets = SDLNet_Read32(serv->paquets->donnee);
                    jeu->map.fichier = (char *)malloc(L_tmpnam);
                    tmpnam(jeu->map.fichier);
                    jeu->map.fichier[0] = '1';
                    fichier = fopen(jeu->map.fichier, "wb");
                    fclose(fichier);
                }
                else //Sinon on continue le tlchargement
                {
                    jeu->map.i++;
                    fichier = fopen(jeu->map.fichier, "ab");
                    fwrite(serv->paquets->donnee, 1, serv->paquets->taille, fichier);
                    fclose(fichier);
                    if(jeu->map.i == jeu->map.paquets) //Si on a tlcharg la map
                    {
                        if(jeu->map.tileset.i == jeu->map.tileset.paquets) //Si on a tlcharg le tileset
                        {
                            charger_map(&(jeu->map));
                            remove(jeu->map.fichier);
                            remove(jeu->map.tileset.fichier);
                        }
                        jeu->charge |= 8;
                    }
                }
                break;
            case PAQUET_TILESET:
                if(jeu->map.tileset.paquets == 0) //Si on n'a pas entam le tlchargement de la map
                {
                    jeu->map.tileset.i = 0;
                    jeu->map.tileset.paquets = SDLNet_Read32(serv->paquets->donnee);
                    jeu->map.tileset.fichier = (char *)malloc(L_tmpnam);
                    tmpnam(jeu->map.tileset.fichier);
                    fichier = fopen(jeu->map.tileset.fichier, "wb");
                    jeu->map.tileset.fichier[0] = '2';
                    fclose(fichier);
                }
                else //Sinon on continue le tlchargement
                {
                    jeu->map.tileset.i++;
                    fichier = fopen(jeu->map.tileset.fichier, "ab");
                    fwrite(serv->paquets->donnee, 1, serv->paquets->taille, fichier);
                    fclose(fichier);
                    if(jeu->map.tileset.i == jeu->map.tileset.paquets) //Si on a tlcharg le tileset
                    {
                        if(jeu->map.i == jeu->map.paquets) //Si on a tlcharg la map
                        {
                            charger_map(&(jeu->map));
                            remove(jeu->map.fichier);
                            remove(jeu->map.tileset.fichier);
                        }
                        jeu->charge |= 16;
                    }
                }
                break;
            case AJOUTER_PION:
                temp = SDLNet_Read32(serv->paquets->donnee);
                ajouter_pion(jeu, SDLNet_Read32(serv->paquets->donnee + 4) + 1, SDLNet_Read32(serv->paquets->donnee + 8), serv->paquets->donnee[29], SDLNet_Read32(serv->paquets->donnee + 12), SDLNet_Read32(serv->paquets->donnee + 16));
                jeu->pions[temp].graal = SDLNet_Read32(serv->paquets->donnee + 20);
                jeu->pions[temp].pts = serv->paquets->donnee[28];
                break;
            case EXPLORE:
                temp = SDLNet_Read32(serv->paquets->donnee);
                for(i = 0; i < jeu->map.hauteur; i++)
                {
                    if(serv->paquets->donnee[i + 4]) {jeu->map.cases[temp][i].etat = MASQUE;}
                    else {jeu->map.cases[temp][i].etat = INCONNU;}
                }
                if(temp == jeu->map.largeur - 1) jeu->charge |= 32;
                break;
            case TOUR:
                jeu->tour = SDLNet_Read32(serv->paquets->donnee);
                sprintf(buffer, "C'est au tour de %s.", jeu->joueurs[jeu->tour].pseudo);
                afficher_message(inter, buffer, jeu->joueurs[jeu->tour].couleur.r, jeu->joueurs[jeu->tour].couleur.g, jeu->joueurs[jeu->tour].couleur.b);
                break;
            case PAQUET_DEPLACEMENT:
                temp = SDLNet_Read32(serv->paquets->donnee);
                ajouter_anim(&(jeu->pions[temp]), DEPLACEMENT, SDLNet_Read32(serv->paquets->donnee + 4) - jeu->pions[temp].pos_x, SDLNet_Read32(serv->paquets->donnee + 8) - jeu->pions[temp].pos_y, 0);
                break;
            case PTS_MVT:
                temp = SDLNet_Read32(serv->paquets->donnee);
                jeu->pions[temp].pts = SDLNet_Read32(serv->paquets->donnee + 4);
                break;
            case PAQUET_COMBAT:
                temp = SDLNet_Read32(serv->paquets->donnee);
                jeu->pions[temp].graal = 0; //En perdant un combat, il perd un ventuel graal
                ajouter_anim(&(jeu->pions[temp]), TELEPORTATION, SDLNet_Read32(serv->paquets->donnee + 4), SDLNet_Read32(serv->paquets->donnee + 8), 0);
                break;
            case MODIF_GRAAL:
                if(serv->paquets->taille == 8) //Kaaptur du graal
                {
                    temp = SDLNet_Read32(serv->paquets->donnee);
                    i = SDLNet_Read32(serv->paquets->donnee + 4);
                    jeu->pions[temp].graal = 1; //graal port
                    jeu->pions[i].graal = jeu->pions[temp].joueur; //ce pion porte le graal prcdent
                    ajouter_anim(&(jeu->pions[temp]), TELEPORTATION, jeu->pions[i].pos_x, jeu->pions[i].pos_y, 0);
                    sprintf(buffer, "%s a pris le graal de %s !", jeu->joueurs[jeu->pions[i].joueur].pseudo, jeu->joueurs[jeu->pions[temp].joueur].pseudo);
                    afficher_message(inter, buffer, jeu->joueurs[jeu->pions[i].joueur].couleur.r, jeu->joueurs[jeu->pions[i].joueur].couleur.g, jeu->joueurs[jeu->pions[i].joueur].couleur.b);
                }
                else if(serv->paquets->taille == 12) //Perte du graal
                {
                    temp = SDLNet_Read32(serv->paquets->donnee);
                    jeu->pions[temp].graal = 0;
                    for(i = 0; i < jeu->nbr_pions; i++) {if(jeu->pions[i].graal == jeu->pions[temp].joueur) {jeu->pions[i].graal = 0;}}
                    ajouter_anim(&(jeu->pions[temp]), TELEPORTATION, SDLNet_Read32(serv->paquets->donnee + 4), SDLNet_Read32(serv->paquets->donnee + 8), 0);
                    if(SDLNet_Read32(serv->paquets->donnee + 4) != jeu->joueurs[jeu->pions[temp].joueur].camp_x || SDLNet_Read32(serv->paquets->donnee + 8) != jeu->joueurs[jeu->pions[temp].joueur].camp_y) {sprintf(buffer, "Le graal de %s est tomb !", jeu->joueurs[jeu->pions[temp].joueur].pseudo);}
                    else {sprintf(buffer, "Le graal de %s a t replac !", jeu->joueurs[jeu->pions[temp].joueur].pseudo);}
                    afficher_message(inter, buffer, jeu->joueurs[jeu->pions[temp].joueur].couleur.r, jeu->joueurs[jeu->pions[temp].joueur].couleur.g, jeu->joueurs[jeu->pions[temp].joueur].couleur.b);
                }
                break;
            case VICTOIRE:
                i = SDLNet_Read32(serv->paquets->donnee);
                temp = SDLNet_Read32(serv->paquets->donnee + 4);
                sprintf(buffer, "%s a gagn en ramenant le graal de %s !", jeu->joueurs[i].pseudo, jeu->joueurs[temp].pseudo);
                afficher_message(inter, buffer, 255, 255, 255);
                Mix_PlayChannel (-1, jeu->sons[0][2], 0); // On lit le son Fin de Partie
                break;
            default: //Dans tous les autres cas, on affiche une erreur
                afficher_message(inter, "Le serveur a envoy un paquet de type inconnu !", 255, 0, 0);
                break;
        }
    }
    if(serv->connecte == 0)
    {
        deconnecter(serv);
        if(jeu->charge == CHARGEMENT_TERMINE) {afficher_message(inter, "Vous avez t dconnect du serveur (erreur serveur) !", 255, 0, 0);}
        else {jeu->charge = -1;}
    }
    return;
}

void lecture_message(t_paquet *mess, t_interface *inter, t_partie *jeu)
{
    long expediteur;
    char buffer[BUFFER_MAX];
    SDL_Color couleur;

    expediteur = SDLNet_Read32(mess->donnee);
    couleur = jeu->joueurs[expediteur].couleur;
    sprintf(buffer, "%s : %s", jeu->joueurs[expediteur].pseudo, mess->donnee + 4);
    afficher_message(inter, buffer, couleur.r, couleur.g, couleur.b);

    if (expediteur!=0)
    {
        Mix_PlayChannel (-1, jeu->sons[0][1], 0); // On lit le son Message
    }
    return;
}

void pause()
{
    SDL_Event event;
    long i;

    for(i = 0; i < DELAI_ENTRE_TENTATIVES / 50; i++)
    {
        while(SDL_PollEvent(&event))
        {
            if(event.type == SDL_QUIT)
            {
                system(CMD_LINE);
                exit(0);
            }
        }
        SDL_Delay(50);
    }
}
